##################################################################
# R code: Exercise 4.4(a) 
# File: Main_4-4(a).r
#
# Main file for computing bootstrapped Gaussianity and linearity 
# test statistics. Subfunctions are in the file "Exercise44.r".
#
# INPUT:  
# data    = time series (here, USunemplmnt_first_dif.dat)
# repnum  = number of MC replications (default = 20) 
# bootnum = number of BS replications (default = 1,000) 
# M = M_{b} = bispectral bandwidth (default = 4)
# p = Bootstrap AR order drawn from the discrete uniform 
#     distribution on {4,5,...,15} 
# rows = number of gridpoints K, drawn from the discrete uniform 
#        distribution on {3,4,5} 
# c = const*M_{b}, with const a U[1.5,3] random deviate
# 
# OUTPUT: 
# Hinich's Gaussianity test statistic (1st column)
# Hinich's linearity test statistic (2nd column)
# BS version of Hinich's Gaussianity test, HG-BS (3rd column)
# BS version of Hinich's linearity test, HL-BS (4th column)
##################################################################
UNEMP   <- ts(data)
repnum  <- 20                   
bootnum <- 1000                 
M.b     <- 4
set.seed(100)  # set position in pseudo-random sequence
UNEMPresults <- array(,dim=c(repnum,4))
parameters   <- array(,dim=c(repnum,4))
for(i in 1:repnum){  
   rows  <- round(runif(1,2.5,5.5)) 
   const <- runif(1,1.5,3)          
   M.s   <- const*M.b
   ar.order <- round(runif(1,3.5,15.5)) 
   ht <- Hinich.test(UNEMP,rows,M.b,M.s)
   bt <- boot.test(bootnum,UNEMP,ar.order,rows,M.b,M.s)
   UNEMPresults[i,] <- c(ht$p_G,ht$p_L,bt$boot.p_G,bt$boot.p_L)
   parameters[i,]   <- c(rows,M.b,M.s,ar.order)
   print(i)
}
reject <- double(4)     # Rejection of null hypothesis
for(j in 1:4){
   sumtt <- 0
   for(i in 1:repnum){
     if(UNEMPresults[i,j]<0.05){#Nominal significance level=5%
     sumtt <- sumtt +1
   }}
   reject[j] <- sumtt/repnum
}